# OTP Selling System - Setup Guide

## Overview

This is a complete PHP + MySQL based OTP (One-Time Password) selling system with:
- User registration and login
- Admin panel for management
- OTP number bulk upload
- Link masking/proxying feature
- Deposit management system
- Beautiful responsive UI

## System Requirements

- PHP 7.4 or higher
- MySQL 5.7 or higher
- Web server (Apache with mod_rewrite or Nginx)
- 100MB disk space

## Installation Steps

### Step 1: Upload Files to Server

1. Connect to your hosting via FTP or File Manager
2. Upload all files to your public_html or www directory
3. Create an `uploads` folder with write permissions (chmod 755)

### Step 2: Run the Installer

1. Open your browser and navigate to: `http://yourdomain.com/install.php`
2. Fill in the database credentials:
   - **Database Host**: Usually `localhost`
   - **Database User**: Usually `root` (or your cPanel username)
   - **Database Password**: Your database password
   - **Database Name**: Create a new name (e.g., `otp_system`)
   - **Site URL**: Your full domain URL (e.g., `http://yourdomain.com/otp_system/`)

3. Click "Continue to Step 2"

### Step 3: Create Admin Account

1. Enter your admin email address
2. Create a strong admin password (minimum 6 characters)
3. Confirm the password
4. Click "Complete Installation"

### Step 4: Access the System

After installation completes:
- **Login URL**: `http://yourdomain.com/login.php`
- **Admin Email**: The email you set during installation
- **Admin Password**: The password you set during installation

## cPanel Installation Instructions

### Using cPanel File Manager:

1. **Create Database**:
   - Go to cPanel → MySQL Databases
   - Create a new database (e.g., `otp_system`)
   - Create a new user and assign it to the database with all privileges

2. **Upload Files**:
   - Go to File Manager
   - Navigate to `public_html`
   - Create a folder named `otp_system`
   - Upload all system files to this folder

3. **Set Permissions**:
   - Right-click on `uploads` folder → Change Permissions
   - Set to `755`
   - Right-click on `config.php` → Change Permissions
   - Set to `644`

4. **Run Installer**:
   - Open browser: `http://yourdomain.com/otp_system/install.php`
   - Follow the installation steps above

### Using SSH (Advanced):

```bash
# Connect to your server
ssh username@yourdomain.com

# Navigate to public_html
cd public_html

# Create directory
mkdir otp_system
cd otp_system

# Upload files (via FTP or SCP)
# Then set permissions
chmod 755 uploads
chmod 644 config.php

# Run installer via browser
```

## Features

### User Features

1. **Registration & Login**
   - Email-based registration
   - WhatsApp number collection
   - Secure password hashing

2. **Dashboard**
   - View current balance
   - See available OTP numbers
   - Quick access to all features

3. **Get OTP**
   - Purchase WhatsApp or Facebook OTP numbers
   - Automatic balance deduction
   - Instant OTP delivery

4. **Deposit**
   - Multiple payment methods
   - Screenshot upload
   - Manual admin approval

5. **History**
   - View all purchased OTPs
   - Access OTP links
   - Track purchases

### Admin Features

1. **Dashboard**
   - Statistics overview
   - Total users, numbers, revenue
   - Pending deposits count

2. **Manage OTP Numbers**
   - Bulk upload via TXT file
   - Manual single entry
   - Delete unused numbers
   - Track available vs sold

3. **Manage Deposits**
   - Review pending deposits
   - Approve or reject requests
   - View payment screenshots
   - Add balance to user accounts

4. **Payment Methods**
   - Add new payment methods
   - Edit payment details
   - Manage active methods

5. **Manage Users**
   - View all users
   - Check user balances
   - Delete inactive users

6. **Settings**
   - Set WhatsApp price
   - Set Facebook price
   - Update service pricing

## Bulk Upload Format

### TXT File Format

Create a `.txt` file with the following format (one entry per line):

```
phone_number|otp_link
3325292763|https://sms222.us?token=i7WGStiD6d01122113
2088477029|https://sms222.us?token=NUjZaCg6hc01122113
7747715099|https://sms222.us?token=wPU34VnxsV01122113
```

**Important**: 
- Each line must have exactly one `|` separator
- Phone number on the left
- OTP link on the right
- No extra spaces or characters

## Link Masking Feature

The system automatically masks OTP links so users see your domain instead of the original source.

**How it works:**
1. Admin uploads: `3325292763|https://sms222.us?token=i7WGStiD6d01122113`
2. User sees: `https://yourdomain.com/proxy.php?token=xxxxx`
3. When user clicks, they're redirected to the actual SMS link
4. The original link remains hidden from users

## Database Structure

### Tables

- **users**: User accounts and balances
- **otp_numbers**: OTP inventory
- **deposits**: Deposit requests
- **purchase_history**: User purchase records
- **deposit_methods**: Available payment methods
- **settings**: System settings

## Security Features

- Password hashing with bcrypt
- SQL injection prevention
- Session-based authentication
- Admin-only access control
- Input sanitization
- File upload validation

## Troubleshooting

### Issue: "Connection failed" during installation
- Check database credentials
- Verify database user has proper permissions
- Ensure MySQL service is running

### Issue: "Permission denied" for uploads folder
- SSH: `chmod 755 uploads`
- cPanel: Right-click folder → Change Permissions → 755

### Issue: Installer keeps redirecting
- Delete `installed.lock` file
- Clear browser cache
- Try again

### Issue: Can't login after installation
- Check that admin email was created correctly
- Verify password is correct (case-sensitive)
- Check browser cookies are enabled

## Default Credentials

After installation, use these to login:
- **Email**: The admin email you set during installation
- **Password**: The admin password you set during installation

## Support

For issues or questions:
1. Check this guide first
2. Verify all files are uploaded correctly
3. Check file permissions
4. Review error messages in browser console
5. Check database connection settings

## File Structure

```
otp_system/
├── config.php              # Database configuration
├── database.sql            # Database schema
├── install.php             # Installation wizard
├── login.php               # Login page
├── register.php            # Registration page
├── proxy.php               # Link masking handler
├── user/
│   ├── dashboard.php       # User dashboard
│   ├── get_otp.php         # Purchase OTP
│   ├── deposit.php         # Deposit funds
│   ├── history.php         # Purchase history
│   └── logout.php          # Logout
├── admin/
│   ├── dashboard.php       # Admin dashboard
│   ├── manage_otp.php      # OTP management
│   ├── manage_deposits.php # Deposit management
│   ├── manage_methods.php  # Payment methods
│   ├── manage_users.php    # User management
│   ├── settings.php        # System settings
│   └── logout.php          # Logout
├── uploads/                # User uploads folder
└── SETUP_GUIDE.md         # This file
```

## Next Steps

1. Complete the installation
2. Login as admin
3. Add payment methods
4. Upload OTP numbers
5. Promote to users
6. Start accepting deposits

---

**System Version**: 1.0
**Last Updated**: 2024
