<?php
require_once '../config.php';
requireAdmin();

$error = '';
$success = '';

// Handle add method
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_method'])) {
    $method_name = sanitize($_POST['method_name'] ?? '');
    $method_details = sanitize($_POST['method_details'] ?? '');
    
    if (empty($method_name)) {
        $error = 'Please enter method name';
    } else {
        $insert_query = "INSERT INTO deposit_methods (method_name, method_details) 
                       VALUES ('$method_name', '$method_details')";
        
        if ($conn->query($insert_query)) {
            $success = 'Payment method added successfully!';
        } else {
            $error = 'Failed to add method: ' . $conn->error;
        }
    }
}

// Handle delete method
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    if ($conn->query("DELETE FROM deposit_methods WHERE id = $id")) {
        $success = 'Payment method deleted successfully!';
    } else {
        $error = 'Failed to delete method';
    }
}

// Get all methods
$methods_query = "SELECT * FROM deposit_methods ORDER BY id DESC";
$methods_result = $conn->query($methods_query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Methods - Admin</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f7fa;
        }
        .navbar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .navbar h2 {
            font-size: 24px;
        }
        .navbar-right {
            display: flex;
            gap: 20px;
            align-items: center;
        }
        .navbar-right a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            padding: 30px 20px;
        }
        .back-link {
            margin-bottom: 20px;
        }
        .back-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
        }
        .page-title {
            color: #333;
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 30px;
        }
        .alert {
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            font-size: 14px;
        }
        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .form-container {
            background: white;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 30px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 500;
        }
        input[type="text"],
        textarea {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
            font-family: inherit;
        }
        input[type="text"]:focus,
        textarea:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        textarea {
            resize: vertical;
            min-height: 100px;
        }
        .btn {
            padding: 12px 30px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 5px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s;
            font-size: 14px;
        }
        .btn:hover {
            transform: translateY(-2px);
        }
        .section-title {
            color: #333;
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #667eea;
        }
        .methods-table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .methods-table th {
            background: #667eea;
            color: white;
            padding: 15px;
            text-align: left;
            font-weight: 600;
        }
        .methods-table td {
            padding: 15px;
            border-bottom: 1px solid #eee;
        }
        .methods-table tr:last-child td {
            border-bottom: none;
        }
        .btn-delete {
            background: #dc3545;
            padding: 8px 15px;
            font-size: 12px;
        }
        .btn-delete:hover {
            background: #c82333;
        }
    </style>
</head>
<body>
    <div class="navbar">
        <h2>🔐 OTP System - Admin</h2>
        <div class="navbar-right">
            <span><?php echo htmlspecialchars($_SESSION['email']); ?></span>
            <a href="logout.php">Logout</a>
        </div>
    </div>

    <div class="container">
        <div class="back-link">
            <a href="dashboard.php">← Back to Dashboard</a>
        </div>

        <h1 class="page-title">💰 Payment Methods</h1>

        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
        <?php endif; ?>

        <div class="form-container">
            <h3 class="section-title">➕ Add Payment Method</h3>
            <form method="POST">
                <div class="form-group">
                    <label for="method_name">Method Name</label>
                    <input type="text" id="method_name" name="method_name" placeholder="e.g., Bank Transfer, PayPal" required>
                </div>
                <div class="form-group">
                    <label for="method_details">Method Details</label>
                    <textarea id="method_details" name="method_details" placeholder="Enter payment details or instructions"></textarea>
                </div>
                <button type="submit" name="add_method" class="btn">Add Method</button>
            </form>
        </div>

        <h3 class="section-title">📋 Payment Methods List</h3>
        <table class="methods-table">
            <thead>
                <tr>
                    <th>Method Name</th>
                    <th>Details</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($methods_result && $methods_result->num_rows > 0): ?>
                    <?php while ($method = $methods_result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($method['method_name']); ?></td>
                            <td><?php echo htmlspecialchars(substr($method['method_details'] ?? '', 0, 50)); ?></td>
                            <td>
                                <span style="display: inline-block; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; background: #d4edda; color: #155724;">
                                    <?php echo $method['is_active'] ? 'Active' : 'Inactive'; ?>
                                </span>
                            </td>
                            <td>
                                <a href="?delete=<?php echo $method['id']; ?>" class="btn btn-delete" onclick="return confirm('Are you sure?')">Delete</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4" style="text-align: center; color: #666;">No payment methods found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
