<?php
session_start();

$step = isset($_GET['step']) ? intval($_GET['step']) : 1;
$error = '';
$success = '';

// Check if already installed
$config_file = 'config.php';
if (file_exists('installed.lock')) {
    die('<div style="padding: 20px; background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; border-radius: 4px;">
        System is already installed. Delete <strong>installed.lock</strong> file to reinstall.
    </div>');
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if ($step == 1) {
        $db_host = sanitize_input($_POST['db_host'] ?? 'localhost');
        $db_user = sanitize_input($_POST['db_user'] ?? 'root');
        $db_pass = sanitize_input($_POST['db_pass'] ?? '');
        $db_name = sanitize_input($_POST['db_name'] ?? 'otp_system');
        $site_url = sanitize_input($_POST['site_url'] ?? 'http://localhost/otp_system/');
        
        // Test database connection
        $conn = @new mysqli($db_host, $db_user, $db_pass);
        if ($conn->connect_error) {
            $error = 'Database connection failed: ' . $conn->connect_error;
        } else {
            // Create database
            if (!$conn->query("CREATE DATABASE IF NOT EXISTS $db_name")) {
                $error = 'Failed to create database: ' . $conn->error;
            } else {
                $conn->select_db($db_name);
                
                // Import database schema
                $sql = file_get_contents('database.sql');
                if ($conn->multi_query($sql)) {
                    while ($conn->next_result()) {
                        if (!$conn->more_results()) break;
                    }
                    $success = 'Database created successfully!';
                    
                    // Update config.php
                    $config_content = "<?php
define('DB_HOST', '$db_host');
define('DB_USER', '$db_user');
define('DB_PASS', '$db_pass');
define('DB_NAME', '$db_name');
define('SITE_URL', '$site_url');
define('SITE_NAME', 'OTP Selling System');

ini_set('session.gc_maxlifetime', 86400);
session_set_cookie_params(86400);
session_start();

try {
    \$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if (\$conn->connect_error) {
        die('Connection failed: ' . \$conn->connect_error);
    }
    \$conn->set_charset('utf8');
} catch (Exception \$e) {
    die('Database Error: ' . \$e->getMessage());
}

function sanitize(\$data) {
    global \$conn;
    return \$conn->real_escape_string(trim(\$data));
}

function redirect(\$url) {
    header('Location: ' . \$url);
    exit();
}

function isLoggedIn() {
    return isset(\$_SESSION['user_id']);
}

function isAdmin() {
    return isset(\$_SESSION['is_admin']) && \$_SESSION['is_admin'] == 1;
}

function requireLogin() {
    if (!isLoggedIn()) {
        redirect(SITE_URL . 'login.php');
    }
}

function requireAdmin() {
    if (!isAdmin()) {
        redirect(SITE_URL . 'index.php');
    }
}
?>";
                    
                    if (file_put_contents('config.php', $config_content)) {
                        $_SESSION['install_step1'] = true;
                        $_SESSION['db_config'] = [
                            'host' => $db_host,
                            'user' => $db_user,
                            'pass' => $db_pass,
                            'name' => $db_name,
                            'url' => $site_url
                        ];
                        $step = 2;
                    } else {
                        $error = 'Failed to update config.php';
                    }
                } else {
                    $error = 'Failed to import database schema: ' . $conn->error;
                }
            }
            $conn->close();
        }
    } elseif ($step == 2) {
        $admin_email = sanitize_input($_POST['admin_email'] ?? '');
        $admin_password = sanitize_input($_POST['admin_password'] ?? '');
        $admin_confirm = sanitize_input($_POST['admin_confirm'] ?? '');
        
        if (empty($admin_email) || empty($admin_password)) {
            $error = 'Please fill all fields';
        } elseif ($admin_password !== $admin_confirm) {
            $error = 'Passwords do not match';
        } elseif (strlen($admin_password) < 6) {
            $error = 'Password must be at least 6 characters';
        } else {
            require_once 'config.php';
            $hashed_password = password_hash($admin_password, PASSWORD_BCRYPT);
            
            $query = "UPDATE users SET email = '$admin_email', password = '$hashed_password' WHERE is_admin = 1 LIMIT 1";
            if ($conn->query($query)) {
                $success = 'Admin user created successfully!';
                $_SESSION['install_step2'] = true;
                $step = 3;
            } else {
                $error = 'Failed to create admin user: ' . $conn->error;
            }
        }
    } elseif ($step == 3) {
        // Create installed.lock file
        if (file_put_contents('installed.lock', date('Y-m-d H:i:s'))) {
            $success = 'Installation completed successfully!';
            $_SESSION['install_complete'] = true;
        } else {
            $error = 'Failed to create lock file';
        }
    }
}

function sanitize_input($data) {
    return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>OTP System - Installation</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        .container {
            background: white;
            border-radius: 10px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            max-width: 500px;
            width: 100%;
            padding: 40px;
        }
        h1 {
            color: #333;
            margin-bottom: 10px;
            text-align: center;
        }
        .step-info {
            text-align: center;
            color: #666;
            margin-bottom: 30px;
            font-size: 14px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 500;
        }
        input[type="text"],
        input[type="email"],
        input[type="password"],
        input[type="url"] {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
            transition: border-color 0.3s;
        }
        input[type="text"]:focus,
        input[type="email"]:focus,
        input[type="password"]:focus,
        input[type="url"]:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        .alert {
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            font-size: 14px;
        }
        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        button {
            width: 100%;
            padding: 12px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s;
        }
        button:hover {
            transform: translateY(-2px);
        }
        .progress {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
        }
        .progress-step {
            flex: 1;
            text-align: center;
            padding: 10px;
            border-radius: 5px;
            background: #f0f0f0;
            margin: 0 5px;
            font-size: 12px;
            color: #666;
        }
        .progress-step.active {
            background: #667eea;
            color: white;
            font-weight: 600;
        }
        .progress-step.completed {
            background: #28a745;
            color: white;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔧 OTP System Installation</h1>
        
        <div class="progress">
            <div class="progress-step <?php echo $step >= 1 ? ($step == 1 ? 'active' : 'completed') : ''; ?>">Step 1: Database</div>
            <div class="progress-step <?php echo $step >= 2 ? ($step == 2 ? 'active' : 'completed') : ''; ?>">Step 2: Admin</div>
            <div class="progress-step <?php echo $step >= 3 ? ($step == 3 ? 'active' : 'completed') : ''; ?>">Step 3: Complete</div>
        </div>

        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo $error; ?></div>
        <?php endif; ?>

        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>

        <?php if ($step == 1): ?>
            <div class="step-info">Configure your database connection</div>
            <form method="POST">
                <div class="form-group">
                    <label for="db_host">Database Host</label>
                    <input type="text" id="db_host" name="db_host" value="localhost" required>
                </div>
                <div class="form-group">
                    <label for="db_user">Database User</label>
                    <input type="text" id="db_user" name="db_user" value="root" required>
                </div>
                <div class="form-group">
                    <label for="db_pass">Database Password</label>
                    <input type="password" id="db_pass" name="db_pass">
                </div>
                <div class="form-group">
                    <label for="db_name">Database Name</label>
                    <input type="text" id="db_name" name="db_name" value="otp_system" required>
                </div>
                <div class="form-group">
                    <label for="site_url">Site URL</label>
                    <input type="url" id="site_url" name="site_url" value="http://localhost/otp_system/" required>
                </div>
                <button type="submit">Continue to Step 2</button>
            </form>

        <?php elseif ($step == 2): ?>
            <div class="step-info">Create admin account</div>
            <form method="POST">
                <div class="form-group">
                    <label for="admin_email">Admin Email</label>
                    <input type="email" id="admin_email" name="admin_email" required>
                </div>
                <div class="form-group">
                    <label for="admin_password">Admin Password</label>
                    <input type="password" id="admin_password" name="admin_password" required>
                </div>
                <div class="form-group">
                    <label for="admin_confirm">Confirm Password</label>
                    <input type="password" id="admin_confirm" name="admin_confirm" required>
                </div>
                <button type="submit">Complete Installation</button>
            </form>

        <?php elseif ($step == 3): ?>
            <div style="text-align: center; padding: 20px;">
                <h2 style="color: #28a745; margin-bottom: 20px;">✓ Installation Complete!</h2>
                <p style="color: #666; margin-bottom: 20px;">Your OTP System is ready to use.</p>
                <a href="login.php" style="display: inline-block; padding: 12px 30px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; text-decoration: none; border-radius: 5px; font-weight: 600;">Go to Login</a>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
