<?php
require_once '../config.php';
requireLogin();

$user_id = $_SESSION['user_id'];

// Get user info
$user_query = "SELECT * FROM users WHERE id = $user_id";
$user_result = $conn->query($user_query);
$user = $user_result->fetch_assoc();

// Get available OTP numbers count
$whatsapp_count = $conn->query("SELECT COUNT(*) as count FROM otp_numbers WHERE is_available = 1 AND service_type = 'whatsapp'")->fetch_assoc()['count'];
$facebook_count = $conn->query("SELECT COUNT(*) as count FROM otp_numbers WHERE is_available = 1 AND service_type = 'facebook'")->fetch_assoc()['count'];

// Get prices
$prices_query = "SELECT * FROM settings WHERE setting_key IN ('whatsapp_price', 'facebook_price')";
$prices_result = $conn->query($prices_query);
$prices = [];
while ($row = $prices_result->fetch_assoc()) {
    $prices[$row['setting_key']] = $row['setting_value'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - OTP System</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f7fa;
        }
        .navbar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .navbar h2 {
            font-size: 24px;
        }
        .navbar-right {
            display: flex;
            gap: 20px;
            align-items: center;
        }
        .navbar-right a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .navbar-right a:hover {
            opacity: 0.8;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 30px 20px;
        }
        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .card {
            background: white;
            border-radius: 10px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            transition: transform 0.3s;
        }
        .card:hover {
            transform: translateY(-5px);
        }
        .card-title {
            color: #666;
            font-size: 14px;
            margin-bottom: 10px;
            text-transform: uppercase;
        }
        .card-value {
            color: #333;
            font-size: 32px;
            font-weight: 700;
            margin-bottom: 10px;
        }
        .card-icon {
            font-size: 40px;
            margin-bottom: 10px;
        }
        .btn {
            display: inline-block;
            padding: 12px 20px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: 600;
            cursor: pointer;
            border: none;
            transition: transform 0.2s;
            font-size: 14px;
        }
        .btn:hover {
            transform: translateY(-2px);
        }
        .btn-secondary {
            background: #6c757d;
        }
        .menu {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 30px;
        }
        .menu-item {
            background: white;
            padding: 20px;
            border-radius: 10px;
            text-align: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            transition: all 0.3s;
            cursor: pointer;
        }
        .menu-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.15);
        }
        .menu-item a {
            text-decoration: none;
            color: inherit;
        }
        .menu-item-icon {
            font-size: 40px;
            margin-bottom: 10px;
        }
        .menu-item-title {
            color: #333;
            font-weight: 600;
            font-size: 16px;
        }
        .section-title {
            color: #333;
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #667eea;
        }
    </style>
</head>
<body>
    <div class="navbar">
        <h2>🔐 OTP System</h2>
        <div class="navbar-right">
            <span><?php echo htmlspecialchars($user['email']); ?></span>
            <a href="logout.php">Logout</a>
        </div>
    </div>

    <div class="container">
        <div class="dashboard-grid">
            <div class="card">
                <div class="card-icon">💰</div>
                <div class="card-title">Balance</div>
                <div class="card-value">$<?php echo number_format($user['balance'], 2); ?></div>
            </div>
            <div class="card">
                <div class="card-icon">📱</div>
                <div class="card-title">WhatsApp Numbers</div>
                <div class="card-value"><?php echo $whatsapp_count; ?></div>
            </div>
            <div class="card">
                <div class="card-icon">👥</div>
                <div class="card-title">Facebook Numbers</div>
                <div class="card-value"><?php echo $facebook_count; ?></div>
            </div>
        </div>

        <h3 class="section-title">📋 Menu</h3>
        <div class="menu">
            <div class="menu-item">
                <a href="get_otp.php">
                    <div class="menu-item-icon">🔑</div>
                    <div class="menu-item-title">Get OTP</div>
                </a>
            </div>
            <div class="menu-item">
                <a href="deposit.php">
                    <div class="menu-item-icon">💳</div>
                    <div class="menu-item-title">Deposit</div>
                </a>
            </div>
            <div class="menu-item">
                <a href="history.php">
                    <div class="menu-item-icon">📜</div>
                    <div class="menu-item-title">History</div>
                </a>
            </div>
        </div>
    </div>
</body>
</html>
